// AGPMDlg.cpp:

#include "stdafx.h"
#include "Defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAGPMDlg

CAGPMDlg::CAGPMDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAGPMDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAGPMDlg)
	m_Find_Address = 0;
	m_Write_Address = 0;
	m_Write_Value = 0;
	m_dwPortNo = 0;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAGPMDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAGPMDlg)
	DDX_Control(pDX, IDC_RADIO_TCP, m_Ctrl_TCP);
	DDX_Control(pDX, IDC_IPADDRESS, m_Ctrl_IPAddress);
	DDX_Control(pDX, IDC_LIST_DEVICE, m_List_Device);
	DDX_Control(pDX, IDC_SLIDER_CONTRAST, m_SL_Contrast);
	DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_SL_Brightness);
	DDX_Text(pDX, IDC_EDIT_FIND_ADDRESS, m_Find_Address);
	DDV_MinMaxInt(pDX, m_Find_Address, 0, 9999);
	DDX_Text(pDX, IDC_EDIT_WRITE_ADDRESS, m_Write_Address);
	DDV_MinMaxInt(pDX, m_Write_Address, 0, 9999);
	DDX_Text(pDX, IDC_EDIT_WRITE_VALUE, m_Write_Value);
	DDV_MinMaxInt(pDX, m_Write_Value, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_PORTNO, m_dwPortNo);
	DDV_MinMaxDWord(pDX, m_dwPortNo, 1024, 65535);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAGPMDlg, CDialog)
	//{{AFX_MSG_MAP(CAGPMDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_SET, OnButtonSet)
	ON_BN_CLICKED(IDC_BUTTON_MONITORING, OnButtonMonitoring)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	ON_EN_CHANGE(IDC_EDIT_FIND_ADDRESS, OnChangeEditFindAddress)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_STOP_MONIT, OnButtonStopMonit)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, OnButtonDisconnect)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_DEVICE, OnDblclkListDevice)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAGPMDlg

BOOL CAGPMDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	// TODO:
	CString	sTmp;

	//Initialization of dialog box
	m_bConnected	= false;
	m_dwPortNo	=	1024;				//	Default port number

	m_Ctrl_IPAddress.SetAddress(0L);
	m_Ctrl_TCP.SetCheck(1);

	m_SL_Brightness.SetRange(0, 7);
	m_SL_Contrast.SetRange(0, 7);
	m_SL_Brightness.SetTic(1);
	m_SL_Contrast.SetTic(1);

	//	The style of the list view is set
	m_List_Device.SetExtendedStyle(m_List_Device.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);

	sTmp.LoadString(IDS_STRING_DEVICE_ADDRESS);
	m_List_Device.InsertColumn(0, _T(sTmp), LVCFMT_RIGHT, 128);
	sTmp.LoadString(IDS_STRING_NUM_VALUE);
	m_List_Device.InsertColumn(1, _T(sTmp), LVCFMT_RIGHT, 127);

	m_Find_Address	=	0;
	m_Write_Address =	0;
	m_Write_Value	=	0;
	UpdateData(FALSE);

	return TRUE;
}

void CAGPMDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CAGPMDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


//When the [Connect] button is pushed
void CAGPMDlg::OnButtonConnect()
{
	if (m_bConnected == true) {
		AfxMessageBox(IDS_STRING_ALREADY);
		return;
	}

	int		iErrorCode		= 0;
	DWORD	WinSockError	= 0;
	DWORD	dwContrast;
	DWORD	dwBrightness;
	DWORD	dwIPAddress;

	BYTE	nField0;		//	IPAddress Each field of eight bit delimitation
	BYTE	nField1;
	BYTE	nField2;
	BYTE	nField3;

	CString	sTmp;


	if (!UpdateData(TRUE)) {
		return;
	}

	if (m_Ctrl_TCP.GetCheck() == 0) { // When UDP is set

		SetTransitionType(B_dwTransitionType_Specific);
		m_IPAddress = NULL;
	}
	else { // When TCP is set
		SetTransitionType(B_dwTransitionType_Only1);
		//	IP address of each field is acquired
		m_Ctrl_IPAddress.GetAddress(nField0, nField1, nField2 ,nField3);
		//	IPaddress is converted into the character string of the dot district switching off
		sTmp.Format("%d.%d.%d.%d", nField0, nField1, nField2, nField3);
		m_IPAddress = sTmp.GetBuffer(256);
	}

	
	//	When the port number is changed from default
	if (m_dwPortNo != MTOM_DEFAULT_PORTNO) {
		m_pMSock->dwPortNo = m_dwPortNo;
	}

	//Connected processing
	if ((iErrorCode = OpenMtoMLAN(m_IPAddress)) != MTOM_OK) {
		WinSockError = MtoMGetLastError();
		sTmp.Format(IDS_STRING_ERROR, iErrorCode, WinSockError);
		AfxMessageBox(sTmp);
		return ;
	}

	if (m_Ctrl_TCP.GetCheck() == 0) { // // When TCP is set
		m_Ctrl_IPAddress.GetAddress(dwIPAddress);
		//	Acquisition of network information
		LPGPNETWORKDATA pNetWorkData = GetGPNetWorkData();

		pNetWorkData->Node[0].dwCheckButton = TRUE;				//	Processing target@
		pNetWorkData->Node[0].dwNodeStatus  = 1;				//	The state of the node is set to existence.
		pNetWorkData->Node[0].dwIPAddress   = dwIPAddress;		//	Setting of IPaddress of node
		m_pMSock->dwIPAddress = dwIPAddress;
	}

	m_bConnected = true;										//	Connected state
	
	sTmp.Format(IDS_STRING_CONNECT);
	MessageBox(sTmp);
	
	//	Initial processing when AGP and connection are done
	MtoMESC_GetContrast(&dwContrast, &dwBrightness);			//	The value of brightness/of present contrast is obtained

	if (dwContrast == IGNORE_CONTRAST) {
		m_SL_Contrast.EnableWindow(FALSE);
	}
	else {
		m_SL_Contrast.EnableWindow(TRUE);
		m_SL_Contrast.SetPos(dwContrast);
	}

	if (dwBrightness == IGNORE_BRIGHTNESS) {
		m_SL_Brightness.EnableWindow(FALSE);
	}
	else {
		m_SL_Brightness.EnableWindow(TRUE);
		m_SL_Brightness.SetPos(dwBrightness);
	}

	if ((dwContrast == IGNORE_CONTRAST) && (dwBrightness == IGNORE_BRIGHTNESS)) {
		GetDlgItem(IDC_BUTTON_SET)->EnableWindow(FALSE);
	}

	UpdateData(FALSE);
}

//	When the [Update] button is pushed
void CAGPMDlg::OnButtonSet()
{
	// There is no processing if it is a unconnection
	if ( m_bConnected == false) {
		AfxMessageBox(IDS_STRING_UNCONNECT);
		return;
	}
	DWORD	dwContrast;
	DWORD	dwBrightness;
	
	if (!UpdateData(TRUE)) {
		return;
	}
	
	if (m_SL_Contrast.IsWindowEnabled() == TRUE) {
		dwContrast = m_SL_Contrast.GetPos();
	}
	else {
		dwContrast =  IGNORE_CONTRAST;
	}
	
	if (m_SL_Brightness.IsWindowEnabled() == TRUE) {
		dwBrightness = m_SL_Brightness.GetPos();
	}
	else {
		dwBrightness =  IGNORE_BRIGHTNESS;
	}

	//Setting of contrast/of present brightness
	MtoMESC_SetContrast(dwContrast, dwBrightness);
	UpdateData(FALSE);
}

//	When the [Monitor start] button is pushed
void CAGPMDlg::OnButtonMonitoring()
{
	// There is no processing if it is a unconnection
	if ( m_bConnected == false) {
		AfxMessageBox(IDS_STRING_UNCONNECT);
		return;
	}
	if (!UpdateData(TRUE)) {
		KillTimer(TIMER_EVENT_ID) ;
		return;
	}
	SetTimer(TIMER_EVENT_ID, TIMER_CYCLE, NULL);
}

void CAGPMDlg::OnTimer(UINT nIDEvent)
{	
	if(nIDEvent != TIMER_EVENT_ID)
	{
		CDialog::OnTimer(nIDEvent);
		return ;
	}

	KillTimer(TIMER_EVENT_ID) ;

	if (!UpdateData(TRUE)) {
		return;
	}
	
	int		iErrorCode = 0;
	
	WORD	pwoData[READ_MAX_DATA]	= {0};
	WORD	wDeviceAddress			= m_Find_Address;
	WORD	wReadNumber				= READ_MAX_DATA;
	DWORD	dwWinSockError			= 0;
	
	CString	sTmp;
	
	if (wDeviceAddress + READ_MAX_DATA >  MAX_ADDRESS) {
		wReadNumber = MAX_ADDRESS - wDeviceAddress + 1;
	}
	m_List_Device.DeleteAllItems();

	//	The data of the system area is read
	if ((iErrorCode = MtoMESC_R(wDeviceAddress, wReadNumber, pwoData)) != MTOM_OK) {
		dwWinSockError = MtoMGetLastError();
		sTmp.Format(IDS_STRING_ERROR, iErrorCode, dwWinSockError);
		AfxMessageBox(sTmp);
		return;
	}

	SetList(wDeviceAddress, pwoData,wReadNumber);				//	It outputs it to the device list

	SetTimer(TIMER_EVENT_ID, TIMER_CYCLE, NULL);

}


//	The list view is displayed.
void CAGPMDlg::SetList(WORD wDeviceAddress, WORD *pwoData, int iDataNum)
{
	
	int	iIndex ;
	CString	sTemp;
		
	for (iIndex = 0; iIndex < iDataNum; iIndex++, pwoData++) {
		sTemp.Format(_T("%04d"), wDeviceAddress + iIndex);
		m_List_Device.InsertItem(iIndex, sTemp);
		sTemp.Format(_T("%d"), *pwoData);
		m_List_Device.SetItem(iIndex, 1, LVIF_TEXT, sTemp, 0, 0, 0, 0);
	}
}


//	When the [Write] button is pushed
void CAGPMDlg::OnButtonWrite()
{
	// There is no processing if it is a unconnection
	if ( m_bConnected == false) {
		AfxMessageBox(IDS_STRING_UNCONNECT);
		return;
	}

	if (!UpdateData(TRUE)) {
		KillTimer(TIMER_EVENT_ID) ;
		return;
	}
	
	int		iErrorCode		= 0;
	WORD	wDeviceAddress;
	WORD	wDeviceValue;
	DWORD	dwWinSockError	= 0;

	CString sTmp;

	wDeviceAddress	=	m_Write_Address;
	wDeviceValue	=	m_Write_Value;

	//	Data is written in the system area
	if ((iErrorCode = MtoMESC_W(wDeviceAddress, 1, &wDeviceValue)) != MTOM_OK) {
		dwWinSockError = MtoMGetLastError();
		sTmp.Format(IDS_STRING_ERROR, iErrorCode, dwWinSockError);
		AfxMessageBox(sTmp);
		return;
	}

	if (abs(wDeviceAddress - m_Find_Address) >= READ_MAX_DATA) {
		m_Find_Address = wDeviceAddress;	//	The written address is brought to the head of the device list
	}
	UpdateData(FALSE);
	SetTimer(TIMER_EVENT_ID, TIMER_CYCLE, NULL);
}

//	When you set the device address
void CAGPMDlg::OnChangeEditFindAddress()
{
	OnButtonStopMonit() ;	// Temporary stop when address is being set
}

//	When [Monitor stop] button is pushed
void CAGPMDlg::OnButtonStopMonit()
{
	KillTimer(TIMER_EVENT_ID);	// Temporary stop
}


void CAGPMDlg::OnButtonDisconnect()
{
	if (m_bConnected == true) {
		CString sTemp ;
		sTemp.Format(IDS_STRING_CUTTING);
		if( MessageBox( (LPCTSTR)sTemp, NULL, MB_ICONQUESTION | MB_OKCANCEL ) != IDOK )
		{
			return ;
		}
		OnButtonStopMonit();	//	Monitor stop
		CloseMtoM();
		m_bConnected = false;
	}
}

void CAGPMDlg::OnDblclkListDevice(NMHDR* pNMHDR, LRESULT* pResult)
{
	// There is no processing if it is a unconnection
	if ( m_bConnected == false) {
		return;
	}

	CWriteDlg	WDlg;

	int		iErrorCode		= 0;
	WORD	wDeviceAddress	= 0;
	WORD	wDeviceValue	= 0;
	DWORD	dwWinSockError	= 0;
	CString	sTmp;

	if (WDlg.DoModal() == IDOK) {
		wDeviceAddress = WDlg.m_Write_Address;
		wDeviceValue = WDlg.m_Write_Value;
		if ((iErrorCode = MtoMESC_W(wDeviceAddress, 1, &wDeviceValue)) != MTOM_OK) {
			dwWinSockError = MtoMGetLastError();
			sTmp.Format(IDS_STRING_ERROR, iErrorCode, dwWinSockError);
			AfxMessageBox(sTmp);
			return;
		}
	}
	*pResult = 0;
}

void CAGPMDlg::OnOK()
{
	if (m_bConnected == true) {
		OnButtonStopMonit();
		CloseMtoM();
	}
	CDialog::OnOK();
}

